//
//  WDDevices.h
//  WDUtility
//
//  Created by Bob Hahn on 3/18/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <DiskArbitration/DiskArbitration.h>
#import "WDDeviceModel.h"

@protocol WDDevicesDelegate;

@interface WDDevices : NSObject
{
    id <WDDevicesDelegate>delegate;
	id pidObject;

    NSMutableDictionary *       mDevices;
    NSMutableDictionary *       mDevDict;    
    DASessionRef				mDASession;
    DAApprovalSessionRef		mDAApprovalSession;
    
    NSMutableDictionary *       dictOfSupportedDevices;
    NSMutableDictionary *       dictOfUnsupportedDevices;
    NSMutableDictionary *       dictOfVCDDevices;
    WDDeviceModel* launchAssociatedDevice; // the device associated with the VCD that SmartWare was launched from during on-boarding
    
    /////////////////// NAS /////////////////////
//    NASDiscovery* bjDiscoveryObject;
    NSMutableDictionary* dictOfNASDevices;
    NSArray* sortedKeysOfDictOfNASDevices;
    NSArray* supportedPIDs;
	NSLock *					dasDevicesLock;

}

@property (readwrite, copy) NSMutableDictionary * mDevices;
@property (readwrite, copy) NSMutableDictionary * mDevDict;
@property (readwrite, copy) NSMutableDictionary * dictOfSupportedDevices;
@property (readwrite, copy) NSMutableDictionary * dictOfUnsupportedDevices;
@property (readwrite, copy) NSMutableDictionary * dictOfVCDDevices;

@property (readwrite, copy) WDDeviceModel* launchAssociatedDevice;
@property (readwrite, copy) NSArray* sortedKeysOfDictOfNASDevices, *supportedPIDs;
@property (nonatomic, assign) id <WDDevicesDelegate>delegate;

+ (WDDevices*) instance;

- (NSArray *)	getSupportedPIDSArray;
- (NSArray *)   getSupportedEncryptedPIDSArray;
- (NSArray *)   getSupportedEncryptedOnyxPIDsValue;

- (void) setDiskAppearanceCallbackToMountableVolumes;
- (void) setDiskAppearanceCallbackToWholeMedia;

- (BOOL) findDevices: (NSArray *)devicePids;

- (NSDictionary *) deviceDictionaries;
- (void) setDelegate: (id<WDDevicesDelegate>) object;

- (void) diskClaim:(DADiskRef) disk;
- (void) diskUnclaim:(DADiskRef) disk;
- (bool) isRAIDDevice: (NSString *) bsdName;

void UnrecognizedDiskPeekCallback(DADiskRef disk, void *context);
void DiskAppearedCallback(DADiskRef disk, void *context);
void DriveDisappearedCallback(DADiskRef disk, void *context);
void diskMountCallback( DADiskRef disk, DADissenterRef dissenter, void *context);
void unmountCallback(DADiskRef disk, DADissenterRef dissenter, void *context);

DADissenterRef mountApprovalCallback(DADiskRef disk, void *context);
void DiskClaimed(DADiskRef disk, DADissenterRef dissenter, void *context );

@end

@protocol WDDevicesDelegate <NSObject>
@optional
- (void)UnrecognizedDiskPeek:(DADiskRef)disk;
- (void)DiskAppeared:(DADiskRef)disk;
- (void)MountableVolumeAppeared: (DADiskRef) disk;
- (void)UnrecognizedVolumeAppeared: (DADiskRef) disk;
- (void)VolumeAppeared:(DADiskRef)disk;
- (void)DriveDisappeared:(DADiskRef)disk;
- (void)DiskClaimed:(DADiskRef)disk;
- (DADissenterRef)DiskClaimRelease:(DADiskRef)disk;
- (DADissenterRef)mountApproval: (DADiskRef) disk;
- (void)diskMount:(DADiskRef)disk;
- (void)lockDevices;
- (void)unlockDevices;

@end